SET TERM ^ ;



CREATE OR ALTER TRIGGER PROCESSOS_MI_RELACIONA_PROCESSO FOR PROCESSOS_MINERAR
ACTIVE AFTER INSERT OR UPDATE POSITION 20
AS

DECLARE VARIABLE COD_DADOS DOM_CODIGO;
BEGIN
  /* Trigger text */
  IF ((NEW.COD_DADOS IS NULL) AND
      (NEW.PROCESSO IS NOT NULL)) THEN
  BEGIN
    SELECT FIRST 1 DADOS.CODIGO
    FROM DADOS
    WHERE DADOS.PROCESSO_CNJ = NEW.PROCESSO AND
          DADOS.SEQ_RECURSO = NEW.SEQ_RECURSO AND
          DADOS.INSTANCIA = NEW.INSTANCIA
    INTO :COD_DADOS;

    IF (:COD_DADOS IS NOT NULL) THEN
    BEGIN
      UPDATE PROCESSOS_MINERAR
      SET PROCESSOS_MINERAR.COD_DADOS = :COD_DADOS
      WHERE PROCESSOS_MINERAR.CODIGO = NEW.CODIGO;
    END
  END
END
^
SET TERM ; ^